#pragma once

class COpenGLControl
{
private:
	HWND hWnd;
	HDC hDC;
	HGLRC hGLRC;

private:
	bool (*initScene)();
	void (*renderScene)();
	void (*resizeScene)(int, int);
	void (*releaseScene)();

public:
	COpenGLControl();
	~COpenGLControl();

	bool initOpenGL(HWND hWnd, bool (*initScene)(), void (*renderScene)(), void (*resizeScene)(int, int), void(*releaseScene)());
	void render();
	void resize(int Width, int Height);
	void releaseOpenGLControl();
};
